<?php
/*--------------------------------------------------------------
   Visualization.php 2021-10-06
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Factory;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Visualization as VisualizationType;

class Visualization
{
    /**
     * Return area chart visualization.
     */
    public function createAreaChart(): VisualizationType
    {
        return VisualizationType::create(VisualizationType::AREA_CHART);
    }
    
    
    /**
     * Return bar chart visualization.
     */
    public function createBarChart(): VisualizationType
    {
        return VisualizationType::create(VisualizationType::BAR_CHART);
    }
    
    
    /**
     * Return pie chart visualization.
     */
    public function createPieChart(): VisualizationType
    {
        return VisualizationType::create(VisualizationType::PIE_CHART);
    }
    
    
    /**
     * Return stacked columns chart visualization.
     */
    public function createStackedColumnsChart(): VisualizationType
    {
        return VisualizationType::create(VisualizationType::STACKED_COLUMNS_CHART);
    }
    
    
    /**
     * Return table visualization.
     */
    public function createTable(): VisualizationType
    {
        return VisualizationType::create(VisualizationType::TABLE);
    }
    
    
    /**
     * Return text visualization.
     */
    public function createText(): VisualizationType
    {
        return VisualizationType::create(VisualizationType::TEXT);
    }
    
    
    /**
     * Return treemap chart visualization.
     */
    public function createTreemapChart(): VisualizationType
    {
        return VisualizationType::create(VisualizationType::TREEMAP_CHART);
    }
    
    
    /**
     * Return radial bar chart visualization.
     */
    public function createRadialBarChart(): VisualizationType
    {
        return VisualizationType::create(VisualizationType::RADIAL_BAR_CHART);
    }
    
    
    /**
     * Return two-sided bar chart visualization.
     */
    public function createTwoSidedBarChart(): VisualizationType
    {
        return VisualizationType::create(VisualizationType::TWO_SIDED_BAR_CHART);
    }
    
    
    public function createDonutChart(): VisualizationType
    {
        return VisualizationType::create(VisualizationType::DONUT_CHART);
    }
}